/******************************************************************************/
/* Header for ADS7843 Resistive Touch Pad Driver			     			  */
/* Programmer : Ramin Jafarpour 									  		  */
/*                                    www.ECA.ir                              */  
/******************************************************************************/

#ifndef __TOUCH_H
#define __TOUCH_H


#include "LPC17xx.h"

/*
7  6 - 4  3      2     1-0
s  A2-A0 MODE SER/DFR PD1-PD0
*/
#define TOUCH_MSR_Y  0x90   
#define TOUCH_MSR_X  0xD0   


// SPI    <==> GPIO
// TP_CS  <==> P0.6  GPIO
// TP_INT <==> P2.13 (EINT3)


#define TP_CS_LOW()                 LPC_GPIO0->FIOCLR = (1<<6);
#define TP_CS_HIGH()                LPC_GPIO0->FIOSET = (1<<6);

#define TP_DOWN()                  (!( LPC_GPIO2->FIOPIN & (1<<13) ) )

/* P0.7 SCK0,P0.8 MISO,P0.9 MOSI */
#define SCK_LOW()          LPC_GPIO0->FIOCLR = (1<<7);
#define SCK_HIGH()         LPC_GPIO0->FIOSET = (1<<7);
#define MOSI_LOW()         LPC_GPIO0->FIOCLR = (1<<9);
#define MOSI_HIGH()        LPC_GPIO0->FIOSET = (1<<9);
#define MISO_value()       ( LPC_GPIO0->FIOPIN & (1<<8) )

void TouchInit(void);
char Touch(unsigned short *X,unsigned short *Y);

#endif

